//
//		Definition of the main game class
//
#ifndef THE_MENU_SCENE_H
#define THE_MENU_SCENE_H


#include "ldwScene.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"

class ldwButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;
class theButterflyClass;
class theStringManager;
class theRealtimeManager;
class theHummingbirdClass;

#define widthOfMenuButtons 190
#define heightOfMenuButtons 30
#define lavaOpacityIncrement 0.008f
#define frontCloudSpeed 0.05f
#define middleCloudSpeed 0.025f
#define backCloudSpeed 0.01f
#define menuPlayButtonX			305
#define menuPlayButtonY			313
#define menuStartOverButtonX	295
#define menuStartOverButtonY	355
#define menuOptionsButtonX		297
#define menuOptionsButtonY		431
#define menuHelpButtonX			316
#define menuHelpButtonY			469
#define menuExitButtonX			335
#define menuExitButtonY			504
#define menuChangePlayerButtonX	291
#define menuChangePlayerButtonY	391

typedef struct {
	
	float frontCloud1X;
	int frontCloud1Y;
	float frontCloud2X;
	int frontCloud2Y;
	float middleCloud1X;
	int middleCloud1Y;
	float middleCloud2X;
	int middleCloud2Y;
	float backCloud1X;
	int backCloud1Y;
	float backCloud2X;
	int backCloud2Y;
	float lavaOpacity;
	float nextLavaOpacityIncrement;

}	DynamicElementDataType;

typedef enum {
	eMenuButtonNULL,
	eMenuButtonPlay,
	eMenuButtonStartOver,
	eMenuButtonOptions,
	eMenuButtonHelp,
	eMenuButtonExit,
	eMenuButtonChangePlayer
}	MenuButtonEnum;

class theMenuScene : public ldwScene
{
public:

	theMenuScene();
	~theMenuScene();

	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);

protected:

	void Activate(bool active);

	void DrawScene();
	void DrawSceneFinal();
	
	void UpdateScene();

	void UpdateShowPlayer();

private:

	ldwGameWindow      *gameWindow;
	theGameState       *gs;
	theButterflyClass  *butterflies;
	theStringManager   *stringMgr;
	theRealtimeManager *realtimeManager;

	theHummingbirdClass *mHummingbirds;

	DynamicElementDataType dynamicElementData;

	float boxAlpha;

	ldwUINT32 butterflySunningTimer;

	bool mouseIsDown;

	ldwPoint mousePos;
	ldwPoint OldMouse;

	ldwRect uiBoxesRect;

	ldwRect playButtonArea;
	ldwRect startOverButtonArea;
	ldwRect optionsButtonArea;
	ldwRect helpButtonArea;
	ldwRect exitButtonArea;
	ldwRect changePlayerButtonArea;
	ldwRect butterflyArea;

	int inWhichButton;

	const int playButtonId;
	const int changePlayerButtonId;
	const int startOverButtonId;
	const int optionsButtonId;
	const int helpButtonId;
	const int exitButtonId;
	const int cPlayerNameLblId;
	const int buynowButtonId;

	ldwButton		*playButton;
	ldwButton		*startOverButton;
	ldwButton		*optionsButton;
	ldwButton		*helpButton;
	ldwButton       *exitButton;
	ldwButton		*changePlayerButton;
	ldwButton		*buynowButton;

	ldwTextControl *versionLabel;
	ldwTextControl *currentPlayer;	
	ldwTextControl *copyrightLabel;
	ldwTextControl *tribeLabel;
};
#endif